    window.__loadedJsLibraries = window.__loadedJsLibraries || (window.__loadedJsLibraries = new Object());
    window.__loadedCssLibraries = window.__loadedCssLibraries || (window.__loadedCssLibraries = new Object());
    if(window.__loadedJsLibraries["/.cm4all/e/assets/js/widget-helper.js"] !== true){
        window.__loadedJsLibraries["/.cm4all/e/assets/js/widget-helper.js"] = true;
        (function() {

  if (window.beng && window.beng.env && window.beng.env.mode != 'deploy') {
    return;
  }
if (!window.getCookieSettings) {
    window.getCookieSettings = function() {return {};};
  }

  var DOM_PARSER = new DOMParser();

  function handleScript(script) {
    var SCRIPT = document.createElement('SCRIPT');
    [].forEach.call(script.attributes, function(attribute) {
      SCRIPT.setAttribute(attribute.name, attribute.value);
    });
    return SCRIPT;
  }


  function importDeep(node) {
    var imported;
    if ('NOSCRIPT' === node.nodeName) {
      return null;
    }
    if ('SCRIPT' === node.nodeName) {
      imported = handleScript(node);
    } else {
      imported = document.importNode(node, false);
    }
    for (var current = node.firstChild; current != null; current = current.nextSibling) {
      var importedNode = importDeep(current);
      if (importedNode) {
        imported.appendChild(importedNode);
      }
    }
    return imported;
  }

  function replaceWithAll(oldNode, newNodes) {
    var all = document.createDocumentFragment();
    [].forEach.call(newNodes, function(node) {
      var importedNode = importDeep(node);
      if (importedNode) {
        all.appendChild(importedNode);
      }
    });
    if (oldNode && oldNode.parentNode) {
      oldNode.parentNode.replaceChild(all, oldNode);
    }
  }

  function displayThirdpartyContent() {
    if (this.checked) {
      var inputList = document.querySelectorAll('.cm-wp-content-switcher__checkbox');
      for (var i = 0; i < inputList.length; i++) {
        var input = inputList[i];
        input.removeEventListener('change', displayThirdpartyContent);
        input.checked = true;
      }
      var cookieSettings = getCookieSettings();
      cookieSettings.thirdparty = true;
      setCookieSettings(cookieSettings);
    }
  }

  function showWidgetPlaceholder(a) {
    var wiid = a.dataset.wiid;
    if (!document.querySelector('[data-ph-wiid="' + wiid + '"]')) {
      var template = document.querySelector('.cm4all-cookie-policy-placeholder-template');
      if (template) {
        var placeholder = template.cloneNode(true);

        placeholder.classList.remove('cm4all-cookie-policy-placeholder-template');
        placeholder.style.display = '';
        placeholder.dataset.phWiid = wiid;
        placeholder.querySelector('input').addEventListener('change', displayThirdpartyContent);
        a.insertAdjacentElement('afterend', placeholder);
      }
    }
  }

  function showWidgetLoadingPlaceholder(a) {
    var wiid = a.dataset.wiid;
    if (!document.querySelector('[data-ph-wiid="' + wiid + '"]')) {
      var placeholder = document.createElement('div');
      // set minHeight asap to avoid too many intersection events before css is loaded
      placeholder.style.minHeight = '200px';
      placeholder.classList.add('cm-widget-loading-placeholder');
      placeholder.innerHTML = '<img src="' + window.beng.env.common_prefix + '/.cm4all/e/static/img/loading_128.gif"></img>'
      placeholder.dataset.phWiid = wiid;
      a.insertAdjacentElement('afterend', placeholder);
    }
  }


  function removeWidgetPlaceholder(a) {
    var placeholder = document.querySelector('[data-ph-wiid="' + a.dataset.wiid + '"]');
    if (placeholder) {
      placeholder.parentNode.removeChild(placeholder);
    }
  }

  var lazyWidgetObserver = null;
  if ("IntersectionObserver" in window) {
    lazyWidgetObserver = new IntersectionObserver(
      function(entries, observer) {
        entries.forEach(function(entry) {
          if (entry.isIntersecting) {
            let lazyWidgetContainer = entry.target;
            var lazyWidgetAnchor = lazyWidgetContainer.querySelector('a.cm4all-cookie-consent');
            lazyWidgetObserver.unobserve(lazyWidgetContainer);
            _loadWidget(lazyWidgetAnchor);
          }
        }
      );
    });
  }


  function _loadWidget(a) {
    var xhr = new XMLHttpRequest();

    xhr.open('GET', a.href);
    xhr.onreadystatechange = function() {
      if (xhr.readyState !== 4) {
        return;
      }
      if (xhr.status === 200) {
        var html = DOM_PARSER.parseFromString(
          '<x-cm4all-root>'
          + xhr.responseText +
          '</x-cm4all-root>', 'text/html')
          .querySelector('x-cm4all-root').childNodes;
        replaceWithAll(a, html);
        removeWidgetPlaceholder(a);
      } else {
        console.log('HTTP error ' + xhr.status + ' ' + xhr.statusText);
      }
    }
    xhr.send();
  }

  function loadWidget(a) {
    if (a.dataset.isLoading !== 'true') {
      a.dataset.isLoading = 'true';
      if (a.dataset.lazy === 'true' && lazyWidgetObserver !== null) {
        lazyWidgetObserver.observe(a.parentNode);
      } else {
        _loadWidget(a);
      }
    }
  }


  function loadWidgets() {

    var cookieSettings = getCookieSettings();

    var widgetAnchorList = document.querySelectorAll('a.cm4all-cookie-consent');

    var widgetsToLoad = [];

    for (var i = 0; i < widgetAnchorList.length; i++) {
      var a = widgetAnchorList[i];
      // var cookieInfo = JSON.parse(widget.dataset.cookieInfo);
      var allowRendering = !cookieSettings.enabled
        || (
          (cookieSettings.thirdparty === true || a.dataset.thirdparty !== 'true')
          &&
          (cookieSettings.statistics === true || a.dataset.statistics !== 'true')
        );
      if (!allowRendering) {
        if (a.dataset.thirdparty === 'true') {
          showWidgetPlaceholder(a);
        }
      } else {
        widgetsToLoad.push(a);
        showWidgetLoadingPlaceholder(a);
      }
    }

    widgetsToLoad.forEach(function(a) {
      loadWidget(a);
    })

    if (!cookieSettings.enabled || cookieSettings.statistics || cookieSettings.noTracking) {
      var scriptList = document.querySelectorAll('script[type="application/x-cm4all-cookie-consent"]');
      for (var i = 0; i < scriptList.length; i++) {
        var script = scriptList[i];
        var html = DOM_PARSER.parseFromString(
          '<x-cm4all-root>' +
          script.dataset.code +
          '</x-cm4all-root>',
          'text/html'
        ).querySelector('x-cm4all-root').childNodes;

        replaceWithAll(script, html);
      }
    }

    var untrustedWidgetAnchorList = document.querySelectorAll('a.cm4all-untrusted-widget');
    for (var i = 0; i < untrustedWidgetAnchorList.length; i++) {
      var a = untrustedWidgetAnchorList[i];
      // todo wiid in dataset
      var wiid = a.id.replace(/^anchor_/, '');
      if (cookieSettings.thirdparty && window.cm4all.initializeUntrustedWidgets) {
        removeWidgetPlaceholder(a);
      } else {
        showWidgetPlaceholder(a);
      }
    }
    if (cookieSettings.thirdparty && window.cm4all.initializeUntrustedWidgets) {
      window.cm4all.initializeUntrustedWidgets();
    }
  }

  window.addEventListener('CookieSettingsChanged', loadWidgets);

  if (document.readyState === 'complete') {
    loadWidgets();
  } else {
    document.addEventListener('DOMContentLoaded', loadWidgets);
  }
})();


(function() {

  function initializeUntrustedWidgets() {
    /*
      iframe per javascript rausschreiben, da ansonsten beim Browser-Back eine alte URL mit ungueltiger
      TransactionId aufgerufen wird. Der IFrame braucht immer eine neue ID/Namen (wegen eines Netscape Memory Leaks)

      Um diverse Bugs mit untrusted-Widgets zu fixen / workarounden, wird folgendes gemacht:
        - Der Translation-Server uebergibt dem xslt-Prozessor seine scope-ID. Diese ID wird vom TS benötigt,
          um den entsprechenden Webspace zu ermitteln.
        - Ist das untrusted-Widget in einer PW-geschuetzten Seite eingebunden, wird die trusted-Variante genommen,
          allerdings wird das sandbox-Attribut angehangen. Dadurch hat das Embed-Widget keinen Zugriff mehr auf Cookies
        - Ansonsten (also außerhalb von PW-geschützten Seiten) wird sichergestellt,
          dass der Scope im Hostnamen des untrusted-Widgets steht.
          Das ist, wenn ein User auf der Webseite eingeloggt ist, eine andere ID.
    */
    if (!window.iframe_suffix){
      window.iframe_suffix = new Date().getTime();
    }
    [].forEach.call(document.querySelectorAll('a.cm4all-untrusted-widget'), function (a) {
      var iframeId = a.id.replace(/^anchor/,'iframe') + '_' + window.iframe_suffix;
      if (document.querySelector('iframe#' +iframeId)) {
        return;
      }
      var iframe = document.createElement('iframe');
      iframe.setAttribute('allowTransparency', 'true');
      iframe.setAttribute('id', iframeId);
      iframe.setAttribute('name', iframeId);
      if (window.beng.env.isProtected) {
        iframe.setAttribute('sandbox', 'allow-modals allow-forms allow-popups allow-scripts');
      }
      iframe.style.width='100%';
      iframe.style.height='100%';
      iframe.style.backgroundColor = 'transparent';
      iframe.style.border ='none';
      iframe.style.display ='block';
      iframe.classList.add('untrustedWidgetFrame');

      a.parentNode.insertBefore(iframe, a.nextSibling);

      if (!window.beng.env.isProtected && window.beng.env.scope) {
        var re = new RegExp("^([0-9]+)(-.*)$");
        var match = re.exec(a.host);
        if (match && match[1] !== window.beng.env.scope) {
          a.host = window.beng.env.scope + match[2];
        }
      }
      var xfti = new window.cm4all.XFrameTunnelInitiator(iframe);
      xfti.open(a.href);
    });
  }

  if (window.beng.env.mode != 'deploy') {
    if (document.readyState === 'complete') {
      initializeUntrustedWidgets();
    } else {
      document.addEventListener('DOMContentLoaded', initializeUntrustedWidgets);
    }
  }

  window.cm4all || {};
  window.cm4all.initializeUntrustedWidgets = initializeUntrustedWidgets;
})();
    };
    window.__loadedCssLibraries["/.cm4all/e/assets/css/base.css"] = true;
