
jQuery(document).ready(function() { 
	Common.doubleTapToGo("#cm_navigation li:has(ul)"); 
	Common.doubleTapToGo("#nav-mobile-heading"); 
});



function checkSubtitleVisibility() {
	
	//Temporarily switch CSS of Subtitle if not visible
	if (jQuery('#subtitle').hasClass('hidden')) {
		jQuery('#subtitle').css({
			position: 'absolute',
			visibility: 'hidden',
			display: 'block'
		});
	}
	
	var titleH1WrapperWidth = jQuery('#title_h1_wrapper').outerWidth();
	var subtitleWrapperWidth = jQuery('#subtitle_wrapper').outerWidth();
	var navigationWrapperWidth = jQuery('#navigation_wrapper').outerWidth();
	var headWrapperWidth = jQuery('#head_wrapper').innerWidth();
	
	//Temporarily switch CSS of Subtitle if not visible
	if (jQuery('#subtitle').hasClass('hidden')) {
		jQuery('#subtitle').css({
			position: '',
			visibility: '',
			display: ''
		});
	}
	
	var fits = ((titleH1WrapperWidth + subtitleWrapperWidth + navigationWrapperWidth - headWrapperWidth) < 0);
	
	if (fits) {
		jQuery('#subtitle_wrapper').removeClass('hidden');
	} else {
		jQuery('#subtitle_wrapper').addClass('hidden');
	}
}

jQuery(document).ready(function() {
	checkSubtitleVisibility();
	jQuery(window).resize(function(){
		checkSubtitleVisibility();
	});

	function setCmEmptyForElements (element, hiddenElement) {
		if(jQuery(element).hasClass('cm_empty')) {
			if(hiddenElement == undefined) {
				jQuery(element).addClass('cm-templates-empty');
			} else {
				jQuery(hiddenElement).addClass('cm-templates-empty');
			}
		}
	}
	
		
	/* focus point - checks for relative or absolute values when focus point is set */
	function isAbsolute(x, y) {
			var isRelative = function(val) {
					return val.match("%$") || val == "auto";
			};
			return !isRelative(x) && !isRelative(y);
	}

	// focus point: backwards-compatibility for px values in logo/kv
	var kvDiv = document.querySelector("[cm_type='keyvisual']");
	if (kvDiv) {
		var kvStyle = window.getComputedStyle(kvDiv);
		if (kvStyle && isAbsolute(kvStyle.backgroundPositionX, kvStyle.backgroundPositionY)) {
			kvDiv.classList.add('cm-templates-kv-deprecated-px');
		}
	}
	var logoDiv = document.querySelector("[cm_type='logo']");
	if (logoDiv) {
		var logoStyle = window.getComputedStyle(logoDiv);
		if (logoStyle && isAbsolute(logoStyle.backgroundPositionX, logoStyle.backgroundPositionY)) {
			logoDiv.classList.add('cm-templates-logo-deprecated-px');
		}
	}


	setTimeout(function() {
		// CM-EMPTY 
		setCmEmptyForElements('.cm-templates-footer'); 
		setCmEmptyForElements('.cm-templates-sidebar-container');
		setCmEmptyForElements('.cm-templates-title-container');
		setCmEmptyForElements('#logo');
		setCmEmptyForElements('#keyvisual');
		setCmEmptyForElements('#title_wrapper');
		setCmEmptyForElements('.title');
		setCmEmptyForElements('.subtitle');
		setCmEmptyForElements('#subtitle_wrapper');
		setCmEmptyForElements('#widgetbar_site_1');
		setCmEmptyForElements('#widgetbar_page_1');
		setCmEmptyForElements('#widgetbar_site_2');
		setCmEmptyForElements('#widgetbar_page_2');


		if(jQuery('#widgetbar_site_1').hasClass('cm_empty') && jQuery('#widgetbar_site_2').hasClass('cm_empty') && jQuery('#widgetbar_page_1').hasClass('cm_empty')
		&& jQuery('#widgetbar_page_2').hasClass('cm_empty')) {
			jQuery('.cm-templates-sidebar-container').addClass('cm-templates-empty');
			jQuery('#content_wrapper .simpleedge').css('border-left-width','1260px');	
			jQuery('#content_wrapper').addClass('cm-content-mobile');
		}

		if(jQuery('.title').hasClass('cm_empty') && jQuery('.subtitle').hasClass('cm_empty')) {
			jQuery('#navigation_wrapper').addClass('cm-nav-mobile');
			jQuery('content_wrapper').addClass('cm-templates-title');
		}

		if(jQuery('.title').hasClass('cm_empty')) {
			jQuery('#title_h1_wrapper').addClass('cm-templates-empty');
		}
		
		if(jQuery('#subtitle_wrapper').hasClass('cm_empty') || jQuery('#title_h1_wrapper').hasClass('cm_empty')) {
			jQuery('#navigation_wrapper').css('max-width', '900px');
		}

	},100);	


	
});